/*"Gear Indicator": Simple OutGauge client for LFS
 * Author: Vladimir Kadlec
 *         vladimirkadlec@gmail.com
 *         http://www.fi.muni.cz/~xkadlec
 * Updated by:  Nick Aronson 29/05/07
 *              nick (dot) a (dot) aronson (at) gmail (dot) com
 * New feature: 5 LED rev meter outputs added
 */
/*
This file is part of Gear Indicator.

Gear Indicator is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Gear Indicator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Gear Indicator; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __OUTSIM_H__
#define __OUTSIM_H__
/*From LFS documentation, InSim.txt, www.liveforspeed.net */

/*
char		1-byte character
byte		1-byte unsigned integer
word		2-byte unsigned integer
short		2-byte signed integer
unsigned	4-byte unsigned integer
int		4-byte signed integer
float		4-byte float
MSHT		4-byte minutes, seconds, hundredths, thousandths
*/

typedef unsigned char byte;
typedef unsigned short word;

#define ISF_RACE_TRACKING	1	// bit 0 : turns on race tracking
#define ISF_GUARANTEE		2	// bit 1 : turns on guaranteed delivery
#define ISF_SPLIT_MESSAGE	4	// bit 2 : use MSS, not MSO for user messages
#define ISF_NO_WARNINGS		8	// bit 3 : turns off packet warnings
#define ISF_KEEP_ALIVE		16	// bit 4 : makes lfs send keep alive packets
#define ISF_NLP_MCI		32	// bit 5 : makes lfs send MCI instead of NLP

typedef struct	// UDP packet to initialise the InSim system
{
	char	Id	[4];	// ISI + zero
	word	Port;		// Port for UDP replies from LFS (0...65535)
	byte	Flags;		// Bit flags for options - see below
	byte	NodeSecs;	// Number of seconds between NLP or MCI packets (0=none)
	char	Admin	[16];// Admin password (required if set in LFS host options)
} __attribute__ ((packed)) InSimInit;

typedef struct { 		// General purpose 8 byte UDP packet
	char	Id	[4];	// 3 character identifier followed by zero character
	int	Value;		// 32 bit value depending on the type of InSimPack
} __attribute__ ((packed)) InSimPack;

typedef struct {
	char	Id	[4];	// VER + zero
	char	Version	[8];	// LFS version, e.g. 0.3G
	char	Product	[6];	// Product : DEMO or S1
	word	InSimVer;	// InSim Version : increased when InSim packets change
} __attribute__ ((packed)) InSimVersion;

typedef struct {
	unsigned int    Time;           // time in milliseconds (to check order)
	char            Car[4];         // Car name
	word            Flags;          // Combination of OG_FLAGS, see below
	byte            Gear;           // Reverse:0, Neutral:1, First:2...
	byte            SpareB;
	float           Speed;          // M/S
	float           RPM;            // RPM
	float           Turbo;          // BAR
	float           EngTemp;        // C
	float           Fuel;           // 0 to 1
	float           OilPress;       // BAR
	float           Spare1;
	float           Spare2;
	float           Spare3;
	float           Throttle;       // 0 to 1
	float           Brake;          // 0 to 1
	float           Clutch;         // 0 to 1
	char            Display1[16];   // Usually Fuel
	char            Display2[16];   // Usually Settings
	int             ID;             // (optional ID - if specified in cfg.txt)
} __attribute__ ((packed)) OutGaugePacket;

#define OG_SHIFTLIGHT   1
#define OG_FULLBEAM     2
#define OG_HANDBRAKE    4
#define OG_PITSPEED     8
#define OG_TC           16
#define OG_HEADLIGHTS   32
#define OG_SIGNAL_L     64
#define OG_SIGNAL_R     128
#define OG_REDLINE      256
#define OG_OILWARN      512
#define OG_1            1024
#define OG_2            2048
#define OG_3            4096
#define OG_4            8192
#define OG_KM           16384
#define OG_BAR          32768

#endif
